/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WindowCrafting
extends ContainerScreen<ContainerCrafting> {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("minecolonies", "textures/gui/crafting2x2.png");
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES3X3 = new ResourceLocation("minecolonies", "textures/gui/crafting3x3.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int GUI_COLOR = 0x404040;
    private static final int X_OFFSET = 97;
    private static final int Y_OFFSET = 8;
    private static final int CRAFTING_GRID_SIZE = 4;
    private static final int MAX_CRAFTING_GRID_SIZE = 9;
    private final AbstractBuildingWorkerView building;
    private final boolean completeCrafting;
    private final CraftingModuleView module;

    public WindowCrafting(ContainerCrafting container, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super((Container)container, playerInventory, iTextComponent);
        this.building = (AbstractBuildingWorkerView)IColonyManager.getInstance().getBuildingView((RegistryKey<World>)playerInventory.field_70458_d.field_70170_p.func_234923_W_(), container.getPos());
        this.module = this.building.getModuleViewMatching(CraftingModuleView.class, v -> v.getId().equals(container.getModuleId()));
        this.completeCrafting = this.module.canLearnLargeRecipes();
    }

    @NotNull
    public AbstractBuildingWorkerView getBuildingView() {
        return this.building;
    }

    public boolean isCompleteCrafting() {
        return this.completeCrafting;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        String buttonDisplay = this.module.canLearnCraftingRecipes() ? I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]) : LanguageHandler.format((String)"com.minecolonies.coremod.gui.recipe.full", (Object[])new Object[0]);
        Button doneButton = new Button(this.field_147003_i + 1, this.field_147009_r + 170, 150, 20, (ITextComponent)new StringTextComponent(buttonDisplay), (Button.IPressable)new OnButtonPress());
        this.func_230480_a_((Widget)doneButton);
        if (!this.module.canLearnCraftingRecipes()) {
            doneButton.field_230693_o_ = false;
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 97.0f, 8.0f, 0x404040);
    }

    protected void func_230450_a_(@NotNull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.completeCrafting) {
            this.field_230706_i_.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES3X3);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        }
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_230430_a_(@NotNull MatrixStack stack, int x, int y, float z) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, x, y, z);
        this.func_230459_a_(stack, x, y);
    }

    public class OnButtonPress
    implements Button.IPressable {
        public void onPress(Button button) {
            if (WindowCrafting.this.module.canLearnCraftingRecipes()) {
                LinkedList<ItemStorage> input = new LinkedList<ItemStorage>();
                for (int i = 0; i < (WindowCrafting.this.completeCrafting ? 9 : 4); ++i) {
                    ItemStack stack = ((ContainerCrafting)((WindowCrafting)WindowCrafting.this).field_147002_h).craftMatrix.func_70301_a(i);
                    ItemStack copy = stack.func_77946_l();
                    ItemStackUtils.setSize(copy, 1);
                    input.add(new ItemStorage(copy));
                }
                ItemStack primaryOutput = ((ContainerCrafting)((WindowCrafting)WindowCrafting.this).field_147002_h).craftResult.func_70301_a(0).getStack().func_77946_l();
                List<ItemStack> secondaryOutputs = ((ContainerCrafting)WindowCrafting.this.field_147002_h).getRemainingItems();
                if (!ItemStackUtils.isEmpty(primaryOutput).booleanValue()) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(WindowCrafting.this.building, input, WindowCrafting.this.completeCrafting ? 3 : 2, primaryOutput, secondaryOutputs, false, WindowCrafting.this.module.getId()));
                }
            }
        }
    }
}

